<?php
require_once __DIR__ . '/../inc/auth.php'; require_login(); if(!is_admin()){ echo 'Admins only'; exit; }
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../partials/header.php';
require_once __DIR__ . '/../inc/helpers.php';
ensure_csrf();
$msg='';
if($_SERVER['REQUEST_METHOD']==='POST'){
  $issue = $_POST['issue_date']; $due = $_POST['due_date']; $notes = $_POST['notes'] ?? '';
  $water = (float)($_POST['water_fee'] ?? 0); $garbage=(float)($_POST['garbage_fee'] ?? 0); $extra=(float)($_POST['extra_fee'] ?? 0);
  $st = $pdo->query("SELECT id, monthly_rent FROM tenants");
  $count=0;
  while($t = $st->fetch()){
    $total = $t['monthly_rent'] + $water + $garbage + $extra;
    $pdo->prepare("INSERT INTO invoices (tenant_id, issue_date, due_date, amount_due, amount_paid, status, notes, water_fee, garbage_fee, extra_fee) VALUES (?,?,?,?,0,'unpaid',?,?,?,?)")
        ->execute([$t['id'], $issue, $due, $total, $notes, $water, $garbage, $extra]);
    $count++;
  }
  $msg="Generated $count invoices.";
}
?>
<h2>Auto-Generate Monthly Invoices</h2>
<?php if($msg): ?><div class="pill"><?= e($msg) ?></div><?php endif; ?>
<form method="post" class="grid">
  <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
  <div class="card"><label>Issue Date</label><input name="issue_date" type="date" value="<?= date('Y-m-d') ?>"></div>
  <div class="card"><label>Due Date</label><input name="due_date" type="date" value="<?= date('Y-m-d', strtotime('+7 days')) ?>"></div>
  <div class="card"><label>Common Notes</label><input name="notes" placeholder="e.g. Rent"></div>
  <div class="card"><label>Water Fee</label><input name="water_fee" type="number" step="0.01" value="0"></div>
  <div class="card"><label>Garbage Fee</label><input name="garbage_fee" type="number" step="0.01" value="0"></div>
  <div class="card"><label>Other Fee</label><input name="extra_fee" type="number" step="0.01" value="0"></div>
  <div class="card"><label>&nbsp;</label><button class="btn primary">Generate</button></div>
</form>
<?php require_once __DIR__ . '/../partials/footer.php'; ?>
